/**
  ******************************************************************************
  * @file    main.c
  * @author  MCU Application Team
  * @brief   Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "py32f410xx_ll_Start_Kit.h"

/* Private define ------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private user code ---------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static void APP_SystemClockConfig(void);
static void APP_ConfigPWMBase(void);
static void APP_ConfigPWMChannel(void);

/**
  * @brief  Main program.
  * @param  None
  * @retval int
  */
int main(void)
{
  /* Enable SYSCFG and PWR clock */
  LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_SYSCFG);
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_PWR);
  
  /* 3 bits for pre-emption priority, 0 bits for subpriority */
  NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_3);

  /* Configure system clock */
  APP_SystemClockConfig();

  /* Enable PWM、GPIO clock */
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_PWM1);
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA | LL_AHB1_GRP1_PERIPH_GPIOC);
  
  /* Configure PWM PWM channels and PWM mode */
  APP_ConfigPWMChannel();
  
  /* Configure and enable PWM PWM2 mode */
  APP_ConfigPWMBase();
  
  while (1)
  {
    
  }
}

/**
  * @brief  Configure PWM PWM related GPIO
  * @param  None
  * @retval None
  */
static void APP_ConfigPWMChannel(void)
{
  LL_GPIO_InitTypeDef PWMCH1MapInit= {0};
  LL_PWM_OC_InitTypeDef PWM_OC_Initstruct ={0};

  /* Set PA4 as PWM_CH1 */
  PWMCH1MapInit.Pin        = LL_GPIO_PIN_4;
  PWMCH1MapInit.Mode       = LL_GPIO_MODE_ALTERNATE;
  PWMCH1MapInit.Alternate  = LL_GPIO_AF_10; 
  PWMCH1MapInit.Speed      = LL_GPIO_SPEED_FREQ_HIGH;
  PWMCH1MapInit.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  PWMCH1MapInit.Pull       = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA,&PWMCH1MapInit);
  
  /* Set PA2 as PWM_CH2 */
  PWMCH1MapInit.Pin        = LL_GPIO_PIN_2;
  PWMCH1MapInit.Mode       = LL_GPIO_MODE_ALTERNATE;
  PWMCH1MapInit.Alternate  = LL_GPIO_AF_10;
  LL_GPIO_Init(GPIOA,&PWMCH1MapInit);
  
  /* Set PC2 as PWM_CH3 */
  PWMCH1MapInit.Pin        = LL_GPIO_PIN_2;
  PWMCH1MapInit.Mode       = LL_GPIO_MODE_ALTERNATE;
  PWMCH1MapInit.Alternate  = LL_GPIO_AF_10; 
  LL_GPIO_Init(GPIOC,&PWMCH1MapInit);
  
  PWM_OC_Initstruct.OCMode        = LL_PWM_OCMODE_PWM2;     /* Mode: PWM2 */
  PWM_OC_Initstruct.OCState       = LL_PWM_OCSTATE_ENABLE;  /* Channel enable */
  PWM_OC_Initstruct.OCNState      = LL_PWM_OCSTATE_DISABLE; /* Complementary channel disable */
  PWM_OC_Initstruct.OCPolarity    = LL_PWM_OCPOLARITY_HIGH; /* Active polarity: high level */
  PWM_OC_Initstruct.OCNPolarity   = LL_PWM_OCPOLARITY_HIGH; /* Compare complementary output polarity: HIGH */
  /* Channel 1 compare value: 250 */
  PWM_OC_Initstruct.CompareValue  = 250;
  /* Configure channel 1 */
  LL_PWM_OC_Init(PWM1,LL_PWM_CHANNEL_CH1,&PWM_OC_Initstruct);
  /* Channel 2 comparison value:500 */
  PWM_OC_Initstruct.CompareValue  = 500;
  /* Configure channel 2 */
  LL_PWM_OC_Init(PWM1,LL_PWM_CHANNEL_CH2,&PWM_OC_Initstruct);
  /* Channel 3 comparison value:750 */
  PWM_OC_Initstruct.CompareValue  = 750;
  /* Configure channel 3 */
  LL_PWM_OC_Init(PWM1,LL_PWM_CHANNEL_CH3,&PWM_OC_Initstruct);
}

/**
  * @brief  Configure PWM base
  * @param  None
  * @retval None
  */
static void APP_ConfigPWMBase(void)
{
  /* Configure PWM */
  LL_PWM_InitTypeDef PWMCountInit = {0};
 
  PWMCountInit.ClockDivision       = LL_PWM_CLOCKDIVISION_DIV1;   /* Clock no divider */
  PWMCountInit.CounterMode         = LL_PWM_COUNTERMODE_UP;       /* Count mode:up */
  PWMCountInit.Prescaler           = 800-1;                       /* prescaler：800 */
  PWMCountInit.Autoreload          = 1000-1;                      /* Autoreload value：1000 */
  
  /* Initialize PWM */
  LL_PWM_Init(PWM1,&PWMCountInit);
  
  /* Enable output */
  LL_PWM_EnableAllOutputs(PWM1);

  /* Enable PWM */
  LL_PWM_EnableCounter(PWM1);
}

/**
  * @brief  Configure system clock
  * @param  None
  * @retval None
  */
static void APP_SystemClockConfig(void)
{
  /* Enable HSI */
  LL_RCC_HSI_Enable();
  while(LL_RCC_HSI_IsReady() != 1)
  {
  }

  /* Set AHB prescaler: HCLK = SYSCLK */
  LL_RCC_SetAHBPrescaler(LL_RCC_SYSCLK_DIV_1);

  /* Select HSI as system clock source */
  LL_RCC_SetSysClkSource(LL_RCC_SYS_CLKSOURCE_HSI);
  while(LL_RCC_GetSysClkSource() != LL_RCC_SYS_CLKSOURCE_STATUS_HSI)
  {
  }

  /* Set APB1 & APB2 prescaler: PCLK1 = HCLK, PCLK2 = HCLK */
  LL_RCC_SetAPB1Prescaler(LL_RCC_APB1_DIV_1);
  LL_RCC_SetAPB2Prescaler(LL_RCC_APB2_DIV_1);
  
  /* Set systick to 1ms in using frequency set to 8MHz */
  LL_Init1msTick(8000000);

  /* Update the SystemCoreClock global variable(which can be updated also through SystemCoreClockUpdate function) */
  LL_SetSystemCoreClock(8000000);
}

/**
  * @brief  Error handling function
  * @param  None
  * @retval None
  */
void APP_ErrorHandler(void)
{
  /* Infinite loop */
  while (1)
  {
  }
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file：Pointer to the source file name
  * @param  line：assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add His own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* Infinite loop */
  while (1)
  {
  }
}
#endif /* USE_FULL_ASSERT */

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
